﻿using System.Collections.Generic;
using System.Linq;
using HIPS.PcehrDataStore.Schemas;
using HIPS.Web.UI.ViewModels.AssistedRegistration;

namespace HIPS.Web.UI.Conversion.AssistedRegistration
{
    public static class UnregisteredViewModelExtensions
    {
        public static UnregisteredViewModel LoadFromPatientsWithoutPcehr(this UnregisteredViewModel viewModel, IList<PatientWithoutPcehr> patients)
        {
            // Convert all patients to ViewModels and add to UnregisteredPatients collection
            viewModel.UnregisteredPatients.AddRange(patients.Select(p => new UnregisteredPatientViewModel().LoadFromPatientWithoutPcehr(p)));

            return viewModel;
        }
    }
}